<?php
if(!defined('sugarEntry') || !sugarEntry) die('Not A Valid Entry Point');
require_once 'include/SugarLogger/SugarLogger.php';
/**
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Affero General Public License version 3 as published by the
 * Free Software Foundation with the addition of the following permission added
 * to Section 15 as permitted in Section 7(a): FOR ANY PART OF THE COVERED WORK
 * IN WHICH THE COPYRIGHT IS OWNED BY SUGARCRM, SUGARCRM DISCLAIMS THE WARRANTY
 * OF NON INFRINGEMENT OF THIRD PARTY RIGHTS.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Affero General Public License along with
 * this program; if not, see http://www.gnu.org/licenses or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301 USA.

 * @author Jim Mackin <jim@jsmackin.co.uk>
 *
 */
class SuiteColourLogger extends SugarLogger{

    private static $colourMapForeground = array(
        'warn'       => 3,
        'error'      => 1,
        'fatal'      => 0,
    );
    private static $colourMapBackground = array(
        'fatal'      => 1,
    );

    public function __construct(){
        parent::__construct();
        $this->setLogger();
    }

    public function log($level,$message){
        if (!$this->initialized) {
            return;
        }
        //lets get the current user id or default to -none- if it is not set yet
        $userID = (!empty($GLOBALS['current_user']->id))?$GLOBALS['current_user']->id:'-none-';

        //if we haven't opened a file pointer yet let's do that
        if (! $this->fp)$this->fp = fopen ($this->full_log_file , 'a' );


        // change to a string if there is just one entry
        if ( is_array($message) && count($message) == 1 )
            $message = array_shift($message);
        // change to a human-readable array output if it's any other array
        if ( is_array($message) )
            $message = print_r($message,true);

        //write out to the file including the time in the dateFormat the process id , the user id , and the log level as well as the message
        fwrite($this->fp,
            $this->getColourCode($level).strftime($this->dateFormat) . ' [' . getmypid () . '][' . $userID . '][' . strtoupper($level) . '] ' . $message . "\n".$this->clearColourCode()
        );
    }

    private function clearColourCode(){
        return chr(27).'[0m';
    }

    private function getColourCode($level){
        $seq = array();
        if(array_key_exists($level,self::$colourMapForeground)){
            $seq[] = chr(27).'[3'.self::$colourMapForeground[$level].'m';
        }
        if(array_key_exists($level,self::$colourMapBackground)){
            $seq[] = chr(27).'[4'.self::$colourMapBackground[$level].'m';
        }
        if($seq){
            return implode('',$seq);
        }
        return '';
    }

    function setLogger(){
        foreach(LoggerManager::getLoggerLevels() as $key => $level){
            LoggerManager::setLogger($key,'SuiteColourLogger');
        }
    }

}